﻿var changeLogs = {
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-changeLogsTable").a4datatable({            
            advancedFilter: true,
            height: "full",
            stateKey: "ChangeLog",
            ajaxAction: a4.getSurveyAction("GetChangeLogs", "ChangeLog"),
            columns: [
                { "Name": "Id", "Title": resources.LogId, "Data": "Id", "Visible": false, "Type": "numeric" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "EventTime", "Title": resources.EventTime, "Data": "EventTime", "Type": "date" },
                { "Name": "EventType", "Title": resources.EventType, "Data": "EventType", "Type": "enum", "EnumType": "ChangeLogEventType" },
                { "Name": "ObjectType", "Title": resources.ObjectType, "Data": "ObjectType", "Type": "enum", "EnumType": "ChangeLogObjectType" },
                { "Name": "ObjectId", "Title": resources.ObjectId, "Data": "ObjectId", "Type": "numeric" },
                { "Name": "ObjectName", "Title": resources.ObjectName, "Data": "ObjectName" },
                { "Name": "Description", "Title": resources.Description, "Data": "Description" }
            ],
            localizableTexts: { "Search": resources.SearchChangeLogs },
            defaultSorting: { Column: "Id", Ascending: false }
        });
    },
    bindEvents: function () {
        $(".v-exportChangeLogs").on("click", function () {
            var tableParams = changeLogs.datatable.a4datatable("getTableParams");
            a4.callServerMethod(a4.getSurveyAction("CreateExportFile", "ChangeLog"), tableParams,
			    function (result) {
			        window.location.href = a4.getSurveyAction("GetExportFile", "ChangeLog", { fileName: result });
			    },
			    function (error) {
			        a4.onAjaxPageMethodError(error);
			    }
			);
        })
    }
}

$(document).ready(function () {
    changeLogs.initializeDataTable();
    changeLogs.bindEvents();
});